document.addEventListener('DOMContentLoaded', function(){
    async function uploadFileAjax()
    {
        return new Promise((resolve, reject) => {
            let fd = new FormData();
            let files = $('[name=agorderdocument-file]')[0].files;

            if (files.length > 0) {
                fd.append('qty_files', files.length);

                $.each (files, function(key, file) {
                    fd.append('agorderdocument[]', file);
                });

                $.ajax({
                    url: location.href,
                    type: 'post',
                    dataType: 'json',
                    data: fd,
                    contentType: false,
                    processData: false
                }).done(function(data){
                    if (data.success) {
                        resolve();
                    } else {
                        reject(new Error(data.error));
                    }
                })
                .fail(function(){
                    reject(new Error('Ocorreu um erro inesperado.'));
                });
            } else {
                reject(new Error('Nenhum arquivo selecionado.'));
            }
        })
    }

    async function uploadFile()
    {
        let spinHandle = loadingOverlay().activate();

        try {
            await uploadFileAjax();
            $.growl.notice({title: '', message: 'Upload realizado com sucesso!'});
            setTimeout(function(){
                location.reload();
            }, 2000);
        } catch (error) {            
            $.growl.error({title: '', message: error.message});
        } finally{
            loadingOverlay().cancel(spinHandle);
        }
    }

    async function deleteFileAjax(id)
    {
        return new Promise((resolve, reject) => {
            $.ajax({
                url: location.href,
                type: 'post',
                dataType: 'json',
                data: {
                    'agorderdocument_remove': true,
                    'id_agorderdocuments_upload' : id
                },
            }).done(function(data){
                if (data.success) {
                    resolve();
                } else {
                    reject(new Error(data.error));
                }
            })
            .fail(function(){
                reject(new Error('Ocorreu um erro inesperado.'));
            });
        })
    }

    async function deleteFile(id)
    {
        let spinHandle = loadingOverlay().activate();

        try {
            await deleteFileAjax(id);
            $.growl.notice({title: '', message: 'Arquivo removido com sucesso!'});
            setTimeout(function(){
                location.reload();
            }, 600);
        } catch (error) {            
            $.growl.error({title: '', message: error.message});
        } finally{
            loadingOverlay().cancel(spinHandle);
        }
    }

    $('[name=agorderdocument-file]').change(function(){
        let fd = new FormData();
        let files = $(this)[0].files;

        if (files.length > 0) {
            uploadFile();
        }
    });

    $('#otherDocuments .icon-times').click(function(){
        if (confirm("Deseja realmente excluir o arquivo " + $(this).closest('tr').find('td:first-child').text())) {
            deleteFile($(this).closest('tr').attr('data-id'));
        }
    });
})