<?php

class AgOrderDocumentUploads extends AgObjectModel
{
    public static $definition = array(
        'table'     => 'agorderdocuments_upload',
        'primary'   => 'id_agorderdocuments_upload',
        'multilang' => false,
        'fields'    => array(
            'id_agorderdocuments_upload' => ['type' => self::TYPE_INT, ' idate' => 'isInt'],
            'id_order'                   => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'db_type' => 'int'],
            'filename'                   => ['type' => self::TYPE_STRING, 'db_type' => 'varchar(256)'] ,
            'uniqid'                     => ['type' => self::TYPE_STRING, 'db_type' => 'varchar(256)'] ,
            'date_add'                   => ['type' => self::TYPE_DATE, 'db_type' => 'datetime'],
            'date_upd'                   => ['type' => self::TYPE_DATE, 'db_type' => 'datetime'],
            'qtt_downloads'              => ['type' => self::TYPE_INT, 'db_type' => 'int']
        ),
        'indexes' => [
            [
                'fields' => ['id_order'],
                'name' => 'search_index'
            ],
            [
                'fields' => ['uniqid'],
                'prefix' => 'unique',
                'name' => 'uniqueid'
            ]
        ]
    );

    public $id_agorderdocuments_upload;
    public $id_order;
    public $filename;
    public $uniqid;
    public $date_add;
    public $date_upd;
    public $qtt_downloads;

    public static function findByIdOrder($id_order)
    {
        $sql = new DbQuery;
        $sql->from('agorderdocuments_upload')
        ->where('id_order='. (int) $id_order);

        return Db::getInstance()->executeS($sql);
    }

    public static function findByUniqid($uniqid)
    {
        $sql = new DbQuery;
        $sql->from('agorderdocuments_upload')
        ->where('uniqid="'. pSQL($uniqid) . '"');

        return Db::getInstance()->getRow($sql);
    }

    public function checkEmployeePermission(Employee $e)
    {
        $order = new Order($this->id_order);

        $sql = new DbQuery;
        $sql->select('id_shop')
            ->from('employee_shop')
            ->where('id_employee=' . (int)$e->id)
            ->where('id_shop=' . (int)$order->id_shop);

        return (int) Db::getInstance()->getValue($sql) != 0;
    }
}