$(function(){
	$('#tabCustomersTypePerson .new_type_person').click(function(){
		var new_type_person = $('#tabCustomersTypePerson .type-person:first-child').clone();

		//substitui os identificadores dos inputs clonados
		var tmp_html = new_type_person.html();
		tmp_html = tmp_html.replace(/\[0\]/g, "[" + $('#tabCustomersTypePerson .type-person').length + "]");
		new_type_person.html(tmp_html);

		$(new_type_person).find('input').val('');
		new_type_person.insertBefore($(this).closest('.text-center'));


		var input_hidden = $(new_type_person).find(' input');
		var value = $('#tabCustomersTypePerson [hidden=hidden]').length;
		input_hidden[0].value = value;

		var btn_danger = $(new_type_person).find('.btn-danger').removeAttr('disabled');
		return false;
	});

	$(document).on('click', '.btn-danger', function(){
		if (!confirm("Essa operação é irreversível. Deseja realmente excluir esse tipo de pessoa?")) {
			return false;
		}

		$(this).closest('.type-person').remove();
		return false;
	})

	//botão de inserir campo no cadastro do cliente
	$('#tabCustomers .nav li .icon-plus').closest('a').click(function(){
		if ($(this).is('.disabled')) {
			return false;
		}

		var tabs_links = $('#tabCustomers ul.nav li');
		$(tabs_links).filter(function(){
			if ($(this).is('.active')) {
				return true;
			}
		}).removeClass('active');

		//clona o link
		var new_tab = $(tabs_links[1]).clone();
		new_tab.find('a').attr('href', '#tabCustomers' + tabs_links.length).text('Novo campo').closest('li').addClass('active');
		new_tab.insertBefore($('#tabCustomers ul.nav li:last-child'));
		new_tab.find('i').removeClass('disabled').removeAttr('disabled').removeAttr('title');		

		//clona o painel
		var panel = $($(tabs_links[1]).find('a').attr('href'));
		panel.siblings('.active').removeClass('active');
		
		var new_tab_panel = panel.clone();
		new_tab_panel.attr('id', 'tabCustomers' + tabs_links.length);
		new_tab_panel.find('.panel-heading').text('Novo campo');
		new_tab_panel.addClass('active');

		var tmp_html = new_tab_panel.html();
		tmp_html = tmp_html.replace(/\[0\]/g, "[" + $('#tabCustomers .customer_input').length + "]");
		new_tab_panel.html(tmp_html);
		new_tab_panel.insertBefore(panel);

		new_tab_panel.find('.mask').removeAttr('hidden');
		new_tab_panel.find('input[type=text]')
			.val('')
			.removeAttr('disabled');
		new_tab_panel.find('.mask').attr('hidden', 'hidden');

		new_tab_panel.find('.form-group.name').show();
		new_tab_panel.find('.form-group.mask').show();

		return false;
	});

	function renderRemoveFieldIcon()
	{
		var i = $('<i/>', {class: 'icon icon-times'});
		return i;
	}

	//ajuste de layout no campo de nome dos tipos de pessoa
	if ($('form[name=agcustomers]').attr('data-authenticated') != 1) {
		$('#tabCustomersTypePerson, #tabCustomerscpf').find('input').attr('disabled', true);
		$('#tabCustomersTypePerson .new_type_person').attr('disabled', true);
		$('#tabCustomers .nav .icon-plus').parent().addClass('disabled');
		$($('#tabAddresses .panel')[1]).find('input').prop('disabled', true);
		$('[name="AGCUSTOMERS_CONFIG\[config\]\[cep_provider\]"]').prop('disabled', true); 
	}

	//impede a edição do nome dos campos padrão do cadastro do cliente
	$('.customer_input .name').each(function(i){
		if (i < 5) {
			$(this).hide();
		}
	});

	//impede a edição da máscara dos campos padrão do cadastro do cliente
	$('.customer_input .mask').each(function(i){
		if (i < 5) {
			$(this).hide();
		}
	});

	//insere o campo para remover campos do cadastro do cliente
	$('#tabCustomers ul.nav li:not(:first-child):not(:last-child)').each(function(i){
		var icon = renderRemoveFieldIcon();
		if (i < 5) {
			icon
				.addClass('disabled')
				.attr('disabled', true)
				.attr('title', 'Você não pode remover um dos campos padrão do módulo.');
		}

		$(this).append(icon);		
	});

	$('#tabCustomers').on('click', 'li i.icon-times', function(){
		if ($(this).is('.disabled')) {
			return;
		}

		if (confirm('Deseja realmente excluir este campo do cadastro do cliente? Essa operação é irreversível e será processada após o formulário ser salvo.')) {
			var link = $(this).siblings('a');
			$(link.attr('href')).remove();
			$(this).closest('li').remove();
		}

		return false;
	});

	$('.reset_fields').click(function(){
		if (!confirm('Deseja realmente resetar os campos para a configuração inicial do módulo? Essa operação é irreverísvel')) {
			return false;
		}

		var overlay = loadingOverlay().activate();
		$.getJSON(location.href + '&resetFields', function(data){
			if (data.success) {
				window.location.reload();
			} else {
				loadingOverlay().cancel(overlay);
				$.growl.error({title: '', message: 'Ocorreu um erro inesperado.'});
			}
		});

		return false;
	});

	$('.reset_overrides').click(function(){
		if (!confirm('Deseja realmente resetar os overrides do módulo? Essa operação é irreverísvel')) {
			return false;
		}

		var overlay = loadingOverlay().activate();
		$.getJSON(location.href + '&resetOverrides', function(data){
			if (data.success) {
				window.location.reload();
			} else {
				loadingOverlay().cancel(overlay);
				$.growl.error({title: '', message: 'Ocorreu um erro inesperado.'});
			}
		});

		return false;
	});
});