$(function(){
	function buildChangelog(module_name, changelog)
	{
		var container = document.createElement('div');
		container.classList.add('agcliente-changelog');

		var header = document.createElement('h3');
		header.innerText = 'Changelog do módulo ' + module_name;
		container.appendChild(header);

		for (var i = 0; i < changelog.length; i++) {
			var row = document.createElement('div');
			row.classList.add('agcliente-changelog-row');
			container.appendChild(row);

			var version = document.createElement('h4');
			version.classList.add('agcliente-changelog-row-version');
			version.innerText = 'Versão ' + changelog[i].version_number;
			row.appendChild(version);


			var text = document.createElement('div');
			text.classList.add('agcliente-changelog-row-body');
			text.innerHTML = changelog[i].changelog;
			row.appendChild(text);
		}

		return container;
	}

	function changelogClicked()
	{
		var tr = this.parentNode.parentNode.parentNode.parentNode;
		var module_name = tr.dataset.name;

		getChangelogByModule(module_name)
		.then(function(changelog){
			var body = buildChangelog(module_name, changelog);

			var modal = new AgModal({
				content:  body,
				dom_id : 'agcliente_changelog',
				onclose: function(){
					modal.destroy();
				}
			});

			modal.open();
		})
		.catch(function(error) {
			$.growl.error({title: '', message: error.message});
		});
	}

	function getChangelogByModule(module_name)
	{
		var promise = new Promise(function(resolve, reject) {
			$.ajax({
				url: url_download + '&getchangelog&module_name=' + module_name,
				type: 'GET',
				dataType : 'JSON',
				success: function(data) {
					if (data.success) {
						resolve(data.changelog);
					} else {
						if (typeof data.error !== 'undefined') {
							reject(new Error(data.error));
						} else {
							reject(new Error('Ocorreu um erro inesperado.'));
						}
					}
				},
				error: function(){
					reject(new Error('Ocorreu um erro inesperado.'));
				}
			});
		});

		return promise;
	}

	$('#agclienteTabUpgrade .update').click(function(){
		var that = this;
		var module_name = $(that).closest('tr').attr('data-name');

		$.ajax({
			url: url_download + '&agdownload&module_name=' + module_name + '&ajaxdownload=true',
			type: 'GET',
			dataType: 'json',
			success: function(data){
				if (data.success) {
					$.growl.notice({title: '', message: data.message});
				} else {
					$.growl.error({title: '', message: data.message});
				}
			},
			error: function(){
				$.growl.error({title: '', message: 'An unexpected error has occurred.'});
			}
		})
	});

	var changelogs = document.querySelectorAll('#agclienteTabUpgrade .changelog');	
	for (var i=0; i<changelogs.length; i++) {
		changelogs[i].addEventListener('click', changelogClicked);
	}
});