document.addEventListener('DOMContentLoaded', function(){
	var divs_shippings = document.querySelectorAll('#addressShipping, #addressInvoice');

	function getPhoneNumber(id_address, cb)
	{
		$.ajax({
			url: 'ajax-tab.php',
			dataType: 'JSON',
			data: {
				action: 'GetPhoneNumber',
				controller : 'AdminAgWpButtonAddress',
				ajax : true,
				token: agwpbutton_address_token,
				id_address : id_address,
			},
			success: function(data) {
				if (typeof data.success && data.success && data.phone != '') {
					cb(data.phone);
				}
			},
			error: function(){

			}
		})
	}

	function addWpButtonToDiv(div)
	{
		var btn_edit = div.querySelector('.well a.btn-default');
		var address = btn_edit.href.match(/id_address=([0-9]*)/);
		var id_address = address[1];

		getPhoneNumber(id_address, function(phone){
			var link = document.createElement('a');
			link.href = 'https://api.whatsapp.com/send?phone=' + phone;
			link.target = '_blank';

			link.classList.add('agwpbutton');

			var img_normal = document.createElement('img');
			img_normal.src = agwpbutton_base_url + 'modules/agwpbutton/views/img/whatsapp.png';
			img_normal.classList.add('normal');

			var img_hover = document.createElement('img');
			img_hover.src = agwpbutton_base_url + 'modules/agwpbutton/views/img/whatsapp_hover.png';
			img_hover.classList.add('hover');

			link.appendChild(img_normal);
			link.appendChild(img_hover);

			btn_edit.parentNode.appendChild(link);
		});
	}

	addWpButtonToDiv(divs_shippings[0]);
	addWpButtonToDiv(divs_shippings[1]);
});