<?php

class AdminAgWpButtonAddressController extends ModuleAdminController
{
	public function ajaxProcessGetPhoneNumber()
	{
		$id_address = Tools::getValue('id_address');
		$address = new Address($id_address);

		if ($address->phone_mobile) {
			$country = new Country($address->id_country);
			$phone = $address->phone_mobile;
		} elseif ($address->phone) {
			$country = new Country($address->id_country);
			$phone = $address->phone;
		}

		if (@$phone) {
			preg_match_all('!\d+!', $phone, $phone);

			$phone = $country->call_prefix . join('', $phone[0]);

			echo Tools::jsonEncode([
				'success' => true,
				'phone' => $phone
			]);
		} else {
			echo Tools::jsonEncode([
				'success' => false
			]);
		}

		exit();
	}

	public function ajaxProcessGetPhoneNumberFromOrder()
	{
		$id_order = Tools::getValue('id_order');
		$order = new Order($id_order);

		$address_invoice = new Address($order->id_address_invoice);

		if ($address_invoice->phone_mobile) {
			$country_invoice = new Country($address_invoice->id_country);
			$phone_invoice = $address_invoice->phone_mobile;
		} elseif ($address_invoice->phone) {
			$country_invoice = new Country($address_invoice->id_country);
			$phone_invoice = $address_invoice->phone;
		}

		$address_delivery = new Address($order->id_address_delivery);
		if ($address_delivery->phone_mobile) {
			$country_delivery = new Country($address_delivery->id_country);
			$phone_delivery = $address_delivery->phone_mobile;
		} elseif ($address_delivery->phone) {
			$country_delivery = new Country($address_delivery->id_country);
			$phone_delivery = $address_delivery->phone;
		}

		preg_match_all('!\d+!', $phone_delivery, $phone_delivery);
		preg_match_all('!\d+!', $phone_invoice, $phone_invoice);

		$phone_delivery = $country_delivery->call_prefix . join('', $phone_delivery[0]);
		$phone_invoice = $country_invoice->call_prefix . join('', $phone_invoice[0]);

		echo Tools::jsonEncode([
			'success' => true,
			'phones' => [
				'invoice' => $phone_invoice,
				'delivery' => $phone_delivery
			]
		]);

		exit();
	}
}